package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.comun.UtilDAO;
import com.ejie.ab04b.model.CoordinadorObra;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Pais;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import com.gfi.utils.Utilities;

/**
 * Ab0484s00DaoImpl generated by UDA, 20-feb-2017 12:41:54.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class CoordinadorObraDaoImpl implements CoordinadorObraDao {
	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = "SELECT t1.TEREXP_084 TEREXP084, t1.ANOEXP_084 ANOEXP084, t1.NUMEXP_084 NUMEXP084, t1.TIPCRD_084 TIPCRD084, t1.TIPDOC_084 TIPDOC084, t1.NUMDOC_084 NUMDOC084, t1.FECALT_084 FECALT084, t1.CODOBRA_084 CODOBRA084, t1.FECBAJ_084 FECBAJ084, t1.NOMCRD_084 NOMCRD084, t1.PAISCRD_084 PAISCRD084, t1.PRVCRD_084 PRVCRD084, t1.MUNCRD_084 MUNCRD084, t1.DMUNCRD_084 DMUNCRD084, t1.DIRCRD_084 DIRCRD084, t1.CPOCRD_084 CPOCRD084, t1.TITCRD_084 TITCRD084, t1.ORDEXP_084 ORDEXP084, t1.USUALT_084 USUALT084, t1.FECMOD_084 FECMOD084, t1.USUMOD_084 USUMOD084, t1.DESCCRD_084 DESCCRD084, t1.TLFCRD_084 TLFCRD084, t1.IDAPE_084 IDAPE084, t1.EMAILCRD_084 EMAILCRD084, "
			+ " PROVINCIA.ID ID_PROVINCIA, PROVINCIA.DS_O PROVINCIA, MUNICIPIO.ID ID_MUNICIPIO, MUNICIPIO.DS_O MUNICIPIO, PAIS.ID ID_PAIS, PAIS.DS_O PAIS "
			+ " FROM AB0484S00 t1 LEFT OUTER JOIN PROVINCIA ON (PROVINCIA.ID = t1.PRVCRD_084) LEFT OUTER JOIN MUNICIPIO ON (MUNICIPIO.PROVINCIA_ID = t1.PRVCRD_084 AND MUNICIPIO.ID = t1.MUNCRD_084) LEFT OUTER JOIN PAIS ON (PAIS.ID = t1.PAISCRD_084) ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<CoordinadorObra> rwMap = new RowMapper<CoordinadorObra>() {
		public CoordinadorObra mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			CoordinadorObra coordRet = new CoordinadorObra(
					resultSet.getString("TEREXP084"),
					resultSet.getString("ANOEXP084"),
					resultSet.getInt("NUMEXP084"),
					resultSet.getString("TIPCRD084"),
					resultSet.getString("TIPDOC084"),
					resultSet.getString("NUMDOC084"),
					resultSet.getDate("FECALT084"),
					resultSet.getLong("CODOBRA084"),
					resultSet.getDate("FECBAJ084"),
					resultSet.getString("NOMCRD084"),
					resultSet.getString("PAISCRD084"),
					resultSet.getString("PRVCRD084"),
					resultSet.getString("MUNCRD084"),
					resultSet.getString("DMUNCRD084"),
					resultSet.getString("DIRCRD084"),
					resultSet.getString("CPOCRD084"),
					resultSet.getString("TITCRD084"),
					resultSet.getLong("ORDEXP084"),
					resultSet.getString("USUALT084"),
					resultSet.getDate("FECMOD084"),
					resultSet.getString("USUMOD084"),
					resultSet.getString("DESCCRD084"),
					resultSet.getString("TLFCRD084"),
					resultSet.getLong("IDAPE084"),
					resultSet.getString("EMAILCRD084"));

			if (UtilDAO.hasColumn(resultSet, "ID_PROVINCIA")) {
				Provincia prov = new Provincia();
				prov.setCodProvincia(resultSet.getString("ID_PROVINCIA"));
				prov.setDescripcion(resultSet.getString("PROVINCIA"));
				coordRet.setProvincia(prov);
			}

			if (UtilDAO.hasColumn(resultSet, "ID_MUNICIPIO")) {
				Municipio munic = new Municipio();
				munic.setCodMunicipio(resultSet.getString("ID_MUNICIPIO"));
				munic.setDescripcion(resultSet.getString("MUNICIPIO"));
				coordRet.setMunicipio(munic);
			}

			if (UtilDAO.hasColumn(resultSet, "ID_PAIS")) {
				Pais pais = new Pais();
				pais.setId(resultSet.getString("ID_PAIS"));
				pais.setDsO(resultSet.getString("PAIS"));
				coordRet.setPais(pais);
			}

			return coordRet;
		}
	};

	private RowMapper<CoordinadorObra> rwMapPK = new RowMapper<CoordinadorObra>() {
		public CoordinadorObra mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new CoordinadorObra(resultSet.getString("TEREXP084"),
					resultSet.getString("ANOEXP084"),
					resultSet.getInt("NUMEXP084"),
					resultSet.getString("TIPCRD084"),
					resultSet.getString("TIPDOC084"),
					resultSet.getString("NUMDOC084"),
					resultSet.getDate("FECALT084"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
 dataSource
	 *            DataSource

	 */
	private RowMapper<JerarquiaDto<CoordinadorObra>> rwMapJerarquia = new RowMapper<JerarquiaDto<CoordinadorObra>>() {
		public JerarquiaDto<CoordinadorObra> mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {

			CoordinadorObra ab0484s00 = new CoordinadorObra(
					resultSet.getString("TEREXP084"),
					resultSet.getString("ANOEXP084"),
					resultSet.getInt("NUMEXP084"),
					resultSet.getString("TIPCRD084"),
					resultSet.getString("TIPDOC084"),
					resultSet.getString("NUMDOC084"),
					resultSet.getDate("FECALT084"),
					resultSet.getLong("CODOBRA084"),
					resultSet.getDate("FECBAJ084"),
					resultSet.getString("NOMCRD084"),
					resultSet.getString("PAISCRD084"),
					resultSet.getString("PRVCRD084"),
					resultSet.getString("MUNCRD084"),
					resultSet.getString("DMUNCRD084"),
					resultSet.getString("DIRCRD084"),
					resultSet.getString("CPOCRD084"),
					resultSet.getString("TITCRD084"),
					resultSet.getLong("ORDEXP084"),
					resultSet.getString("USUALT084"),
					resultSet.getDate("FECMOD084"),
					resultSet.getString("USUMOD084"),
					resultSet.getString("DESCCRD084"),
					resultSet.getString("TLFCRD084"),
					resultSet.getLong("IDAPE084"),
					resultSet.getString("EMAILCRD084"));

			JerarquiaDto<CoordinadorObra> jerarquia = new JerarquiaDto<CoordinadorObra>();
			jerarquia.setModel(ab0484s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the coordinador obra
	 */
	public CoordinadorObra add(CoordinadorObra ab0484s00) {
		String query = "INSERT INTO AB0484S00 (TEREXP_084, ANOEXP_084, NUMEXP_084, TIPCRD_084, TIPDOC_084, NUMDOC_084, CODOBRA_084, FECBAJ_084, NOMCRD_084, PAISCRD_084, PRVCRD_084, MUNCRD_084, DMUNCRD_084, DIRCRD_084, CPOCRD_084, TITCRD_084, ORDEXP_084, USUALT_084, FECMOD_084, USUMOD_084, DESCCRD_084, TLFCRD_084, IDAPE_084,  FECALT_084, EMAILCRD_084) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,sysdate,?)";
		this.jdbcTemplate.update(
				query,
				ab0484s00.getTerexp084(),
				ab0484s00.getAnoexp084(),
				ab0484s00.getNumexp084(),
				ab0484s00.getTipcrd084(),
				ab0484s00.getTipdoc084(),
				ab0484s00.getNumdoc084(),
				ab0484s00.getCodobra084(),
				ab0484s00.getFecbaj084(),
				ab0484s00.getNomcrd084(),
				ab0484s00.getPaiscrd084(),
				(!Utilities.isEmpty(ab0484s00.getCodProvincia())) ? ab0484s00
						.getCodProvincia() : ab0484s00.getPrvcrd084(),
				(!Utilities.isEmpty(ab0484s00.getCodMunicipio())) ? ab0484s00
						.getCodMunicipio() : ab0484s00.getMuncrd084(),
				ab0484s00.getDmuncrd084(), ab0484s00.getDircrd084(), ab0484s00
						.getCpocrd084(), ab0484s00.getTitcrd084(), ab0484s00
						.getOrdexp084(), ab0484s00.getUsualt084(), ab0484s00
						.getFecmod084(), ab0484s00.getUsumod084(), ab0484s00
						.getDesccrd084(), ab0484s00.getTlfcrd084(), ab0484s00
						.getIdape084(), ab0484s00.getEmailcrd084());
		return ab0484s00;
	}

	/**
	 * Updates a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the coordinador obra
	 */
	public CoordinadorObra update(CoordinadorObra ab0484s00) {
		String query = "UPDATE AB0484S00 SET CODOBRA_084=?, FECBAJ_084=?, NOMCRD_084=?, PAISCRD_084=?, PRVCRD_084=?, MUNCRD_084=?, DMUNCRD_084=?, DIRCRD_084=?, CPOCRD_084=?, TITCRD_084=?, ORDEXP_084=?, USUALT_084=?, FECMOD_084=?, USUMOD_084=?, DESCCRD_084=?, TLFCRD_084=?, IDAPE_084=? WHERE TEREXP_084=? AND ANOEXP_084=? AND NUMEXP_084=? AND TIPCRD_084=? AND TIPDOC_084=? AND NUMDOC_084=? AND FECALT_084=? AND EMAILCRD_084=?";
		this.jdbcTemplate.update(query, ab0484s00.getCodobra084(),
				ab0484s00.getFecbaj084(), ab0484s00.getNomcrd084(),
				ab0484s00.getPaiscrd084(), ab0484s00.getPrvcrd084(),
				ab0484s00.getMuncrd084(), ab0484s00.getDmuncrd084(),
				ab0484s00.getDircrd084(), ab0484s00.getCpocrd084(),
				ab0484s00.getTitcrd084(), ab0484s00.getOrdexp084(),
				ab0484s00.getUsualt084(), ab0484s00.getFecmod084(),
				ab0484s00.getUsumod084(), ab0484s00.getDesccrd084(),
				ab0484s00.getTlfcrd084(), ab0484s00.getIdape084(),
				ab0484s00.getTerexp084(), ab0484s00.getAnoexp084(),
				ab0484s00.getNumexp084(), ab0484s00.getTipcrd084(),
				ab0484s00.getTipdoc084(), ab0484s00.getNumdoc084(),
				ab0484s00.getFecalt084(), ab0484s00.getEmailcrd084());
		return ab0484s00;
	}

	/**
	 * Finds a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the coordinador obra
	 */
	@Transactional(readOnly = true)
	public CoordinadorObra find(CoordinadorObra ab0484s00) {
		StringBuilder query = new StringBuilder(
				CoordinadorObraDaoImpl.STRING_BUILDER_INIT);
		query.append(CoordinadorObraDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.TEREXP_084 = ? AND t1.ANOEXP_084 = ? AND t1.NUMEXP_084 = ? AND t1.TIPCRD_084 = ? AND t1.TIPDOC_084 = ? AND t1.NUMDOC_084 = ?   AND t1.CODOBRA_084 = ?  ");

		List<CoordinadorObra> ab0484s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMap, ab0484s00.getTerexp084(),
				ab0484s00.getAnoexp084(), ab0484s00.getNumexp084(),
				ab0484s00.getTipcrd084(), ab0484s00.getTipdoc084(),
				ab0484s00.getNumdoc084(), ab0484s00.getCodobra084());
		return (CoordinadorObra) DataAccessUtils.uniqueResult(ab0484s00List);
	}

	/**
	 * Finds a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<CoordinadorObra> findCoordinadorMaxFecAlta(
			CoordinadorObra ab0484s00) {
		StringBuilder select = new StringBuilder(
				CoordinadorObraDaoImpl.STRING_BUILDER_INIT);
		select.append(CoordinadorObraDaoImpl.QUERY_SELECT);
		select.append("WHERE t1.TIPDOC_084 = ? AND t1.NUMDOC_084 = ? ");
		select.append("ORDER BY t1.FECALT_084 DESC");

		return (List<CoordinadorObra>) this.jdbcTemplate.query(
				select.toString(), this.rwMap, ab0484s00.getTipdoc084(),
				ab0484s00.getNumdoc084());
	}

	/**
	 * Removes a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00            Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 */
	public void remove(CoordinadorObra ab0484s00) {
		String query = "DELETE FROM AB0484S00 WHERE TEREXP_084=? AND ANOEXP_084=? AND NUMEXP_084=? AND TIPCRD_084=? AND TIPDOC_084=? AND NUMDOC_084=? ";
		this.jdbcTemplate.update(query, ab0484s00.getTerexp084(),
				ab0484s00.getAnoexp084(), ab0484s00.getNumexp084(),
				ab0484s00.getTipcrd084(), ab0484s00.getTipdoc084(),
				ab0484s00.getNumdoc084());
	}

	/**
	 * Finds a list of rows in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0484s00>
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<CoordinadorObra> findAll(CoordinadorObra ab0484s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				CoordinadorObraDaoImpl.STRING_BUILDER_INIT);
		query.append(CoordinadorObraDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0484s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<CoordinadorObra>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0484s00 table using like.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0484s00>
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<CoordinadorObra> findAllLike(CoordinadorObra ab0484s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				CoordinadorObraDaoImpl.STRING_BUILDER_INIT);
		query.append(CoordinadorObraDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0484s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<CoordinadorObra>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  Long
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(CoordinadorObra ab0484s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0484S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0484s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0484s00 table using like.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(CoordinadorObra ab0484s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0484S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0484s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0484s00 selected for rup_table.
	 * 
	 *  ab0484s00            Ab0484s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0484s00>>
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<CoordinadorObra>> reorderSelection(
			CoordinadorObra ab0484s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				CoordinadorObraDaoImpl.STRING_BUILDER_INIT);
		query.append(CoordinadorObraDaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0484s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getReorderQuery(query, jqGridRequestDto,
						CoordinadorObra.class, filterParamList,
						"TEREXP_084,ANOEXP_084,NUMEXP_084,TIPCRD_084,TIPDOC_084,NUMDOC_084,FECALT_084");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<CoordinadorObra>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab0484s00
	 *  searchParams            Ab0484s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0484s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<CoordinadorObra>> search(
			CoordinadorObra filterParams, CoordinadorObra searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				CoordinadorObraDaoImpl.STRING_BUILDER_INIT);
		query.append(CoordinadorObraDaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getSearchQuery(query, jqGridRequestDto, CoordinadorObra.class,
						filterParamList, searchSQL, searchParamList,
						from_alias,
						"TEREXP_084,ANOEXP_084,NUMEXP_084,TIPCRD_084,TIPDOC_084,NUMDOC_084,FECALT_084");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<CoordinadorObra>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filterab0484s00            Ab0484s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filterab0484s00 the filterab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(CoordinadorObra filterab0484s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				CoordinadorObraDaoImpl.STRING_BUILDER_INIT);
		query.append(CoordinadorObraDaoImpl.QUERY_SELECT);

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0484s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						CoordinadorObra.class, query, params,
						"TEREXP_084,ANOEXP_084,NUMEXP_084,TIPCRD_084,TIPDOC_084,NUMDOC_084,FECALT_084");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab0484s00 table.
	 * 
	 *  filterAb0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<JerarquiaDto<Ab0484s00>>
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<JerarquiaDto<CoordinadorObra>> findAllLikeJerarquia(
			CoordinadorObra filterAb0484s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				CoordinadorObraDaoImpl.STRING_BUILDER_INIT);
		query.append(CoordinadorObraDaoImpl.QUERY_SELECT);
		// StringBuilder from = new StringBuilder("FROM AB0484S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0484S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0484s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia
				.getQuery(
						jqGridRequestDto,
						query,
						mapaWhere,
						"TEREXP_084,ANOEXP_084,NUMEXP_084,TIPCRD_084,TIPDOC_084,NUMDOC_084,FECALT_084",
						"ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy.
	 * 
	 *  filterAb0484s00            Ab0484s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  Long
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the long
	 */
	@Override
	public Long findAllLikeCountJerarquia(CoordinadorObra filterAb0484s00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0484S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0484S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0484s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia
				.getQueryCount(
						jqGridRequestDto,
						mapaWhere,
						"TEREXP_084,ANOEXP_084,NUMEXP_084,TIPCRD_084,TIPDOC_084,NUMDOC_084,FECALT_084",
						"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows.
	 * 
	 *  filterAb0484s00            Ab0484s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  List<TableRowDto<Ab0484s00>>
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<TableRowDto<CoordinadorObra>> findAllChild(
			CoordinadorObra filterAb0484s00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0484S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0484S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0484s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia
				.getQueryChildren(
						jqGridRequestDto,
						mapaWhere,
						"TEREXP_084,ANOEXP_084,NUMEXP_084,TIPCRD_084,TIPDOC_084,NUMDOC_084,FECALT_084",
						"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<CoordinadorObra>(
								this.rwMapPK,
								"TEREXP_084,ANOEXP_084,NUMEXP_084,TIPCRD_084,TIPDOC_084,NUMDOC_084,FECALT_084"),
						params.toArray());
	}

	/**
	 * Inserts a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the coordinador obra
	 */
	public CoordinadorObra addFromSolicitud(CoordinadorObra ab0484s00) {
		String query = "INSERT INTO AB0484S00 (TEREXP_084, ANOEXP_084, NUMEXP_084, TIPCRD_084, TIPDOC_084, NUMDOC_084, CODOBRA_084, FECBAJ_084, NOMCRD_084, PAISCRD_084, "
				+ "PRVCRD_084, MUNCRD_084, DMUNCRD_084, DIRCRD_084, CPOCRD_084, TITCRD_084, ORDEXP_084, USUALT_084, FECMOD_084, USUMOD_084, DESCCRD_084, TLFCRD_084, IDAPE_084,  "
				+ "FECALT_084, EMAILCRD_084) ( "
				+ "SELECT TEREXP_084, ANOEXP_084, NUMEXP_084, TIPCRD_084, TIPDOC_084, NUMDOC_084, CODOBRA_084, FECBAJ_084, NOMCRD_084, PAISCRD_084, "
				+ "PRVCRD_084, MUNCRD_084, DMUNCRD_084, DIRCRD_084, CPOCRD_084, TITCRD_084, ORDEXP_084, USUALT_084, FECMOD_084, USUMOD_084, DESCCRD_084, TLFCRD_084, IDAPE_084,  "
				+ "SYSDATE, EMAILCRD_084 FROM AB0484S01 WHERE CODOBRA_084 = ? )";
		this.jdbcTemplate.update(query, ab0484s00.getTerexp084(),
				ab0484s00.getAnoexp084(), ab0484s00.getNumexp084(),
				ab0484s00.getCodobra084());
		return ab0484s00;
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0484s00 entity.
	 * 
	 *  ab0484s00            Ab0484s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(CoordinadorObra ab0484s00) {

		StringBuilder where = new StringBuilder(
				CoordinadorObraDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0484s00 != null && ab0484s00.getTerexp084() != null) {
			where.append(" AND t1.TEREXP_084 = ?");
			params.add(ab0484s00.getTerexp084());
		}
		if (ab0484s00 != null && ab0484s00.getAnoexp084() != null) {
			where.append(" AND t1.ANOEXP_084 = ?");
			params.add(ab0484s00.getAnoexp084());
		}
		if (ab0484s00 != null && ab0484s00.getNumexp084() != null) {
			where.append(" AND t1.NUMEXP_084 = ?");
			params.add(ab0484s00.getNumexp084());
		}
		if (ab0484s00 != null && ab0484s00.getTipcrd084() != null) {
			where.append(" AND t1.TIPCRD_084 = ?");
			params.add(ab0484s00.getTipcrd084());
		}
		if (ab0484s00 != null && ab0484s00.getTipdoc084() != null) {
			where.append(" AND t1.TIPDOC_084 = ?");
			params.add(ab0484s00.getTipdoc084());
		}
		if (ab0484s00 != null && ab0484s00.getNumdoc084() != null) {
			where.append(" AND t1.NUMDOC_084 = ?");
			params.add(ab0484s00.getNumdoc084());
		}
		if (ab0484s00 != null && ab0484s00.getFecalt084() != null) {
			where.append(" AND t1.FECALT_084 = ?");
			params.add(ab0484s00.getFecalt084());
		}
		if (ab0484s00 != null && ab0484s00.getCodobra084() != null) {
			where.append(" AND t1.CODOBRA_084 = ?");
			params.add(ab0484s00.getCodobra084());
		}
		if (ab0484s00 != null && ab0484s00.getFecbaj084() != null) {
			where.append(" AND t1.FECBAJ_084 = ?");
			params.add(ab0484s00.getFecbaj084());
		} else {
			where.append(" AND t1.FECBAJ_084 IS NULL");
		}
		if (ab0484s00 != null && ab0484s00.getNomcrd084() != null) {
			where.append(" AND t1.NOMCRD_084 = ?");
			params.add(ab0484s00.getNomcrd084());
		}
		if (ab0484s00 != null && ab0484s00.getPaiscrd084() != null) {
			where.append(" AND t1.PAISCRD_084 = ?");
			params.add(ab0484s00.getPaiscrd084());
		}
		if (ab0484s00 != null && ab0484s00.getPrvcrd084() != null) {
			where.append(" AND t1.PRVCRD_084 = ?");
			params.add(ab0484s00.getPrvcrd084());
		}
		if (ab0484s00 != null && ab0484s00.getMuncrd084() != null) {
			where.append(" AND t1.MUNCRD_084 = ?");
			params.add(ab0484s00.getMuncrd084());
		}
		if (ab0484s00 != null && ab0484s00.getDmuncrd084() != null) {
			where.append(" AND t1.DMUNCRD_084 = ?");
			params.add(ab0484s00.getDmuncrd084());
		}
		if (ab0484s00 != null && ab0484s00.getDircrd084() != null) {
			where.append(" AND t1.DIRCRD_084 = ?");
			params.add(ab0484s00.getDircrd084());
		}
		if (ab0484s00 != null && ab0484s00.getCpocrd084() != null) {
			where.append(" AND t1.CPOCRD_084 = ?");
			params.add(ab0484s00.getCpocrd084());
		}
		if (ab0484s00 != null && ab0484s00.getTitcrd084() != null) {
			where.append(" AND t1.TITCRD_084 = ?");
			params.add(ab0484s00.getTitcrd084());
		}
		if (ab0484s00 != null && ab0484s00.getOrdexp084() != null) {
			where.append(" AND t1.ORDEXP_084 = ?");
			params.add(ab0484s00.getOrdexp084());
		}
		if (ab0484s00 != null && ab0484s00.getUsualt084() != null) {
			where.append(" AND t1.USUALT_084 = ?");
			params.add(ab0484s00.getUsualt084());
		}
		if (ab0484s00 != null && ab0484s00.getFecmod084() != null) {
			where.append(" AND t1.FECMOD_084 = ?");
			params.add(ab0484s00.getFecmod084());
		}
		if (ab0484s00 != null && ab0484s00.getUsumod084() != null) {
			where.append(" AND t1.USUMOD_084 = ?");
			params.add(ab0484s00.getUsumod084());
		}
		if (ab0484s00 != null && ab0484s00.getDesccrd084() != null) {
			where.append(" AND t1.DESCCRD_084 = ?");
			params.add(ab0484s00.getDesccrd084());
		}
		if (ab0484s00 != null && ab0484s00.getTlfcrd084() != null) {
			where.append(" AND t1.TLFCRD_084 = ?");
			params.add(ab0484s00.getTlfcrd084());
		}
		if (ab0484s00 != null && ab0484s00.getEmailcrd084() != null) {
			where.append(" AND t1.EMAILCRD_084 = ?");
			params.add(ab0484s00.getEmailcrd084());
		}
		if (ab0484s00 != null && ab0484s00.getIdape084() != null) {
			where.append(" AND t1.IDAPE_084 = ?");
			params.add(ab0484s00.getIdape084());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0484s00 entity.
	 * 
	 *  ab0484s00            Ab0484s00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(CoordinadorObra ab0484s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				CoordinadorObraDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0484s00 != null && ab0484s00.getTerexp084() != null) {
			where.append(" AND UPPER(t1.TEREXP_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getTerexp084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getTerexp084().toUpperCase() + "%");
			}
			where.append(" AND t1.TEREXP_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getAnoexp084() != null) {
			where.append(" AND UPPER(t1.ANOEXP_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getAnoexp084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getAnoexp084().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOEXP_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getNumexp084() != null) {
			where.append(" AND t1.NUMEXP_084 = ?");
			params.add(ab0484s00.getNumexp084());
		}
		if (ab0484s00 != null && ab0484s00.getTipcrd084() != null) {
			where.append(" AND UPPER(t1.TIPCRD_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getTipcrd084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getTipcrd084().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPCRD_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getTipdoc084() != null) {
			where.append(" AND UPPER(t1.TIPDOC_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getTipdoc084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getTipdoc084().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPDOC_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getNumdoc084() != null) {
			where.append(" AND UPPER(t1.NUMDOC_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getNumdoc084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getNumdoc084().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMDOC_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getFecalt084() != null) {
			where.append(" AND t1.FECALT_084 = ?");
			params.add(ab0484s00.getFecalt084());
		}
		if (ab0484s00 != null && ab0484s00.getCodobra084() != null) {
			where.append(" AND t1.CODOBRA_084 = ?");
			params.add(ab0484s00.getCodobra084());
		}
		if (ab0484s00 != null && ab0484s00.getFecbaj084() != null) {
			where.append(" AND t1.FECBAJ_084 = ?");
			params.add(ab0484s00.getFecbaj084());
		}
		if (ab0484s00 != null && ab0484s00.getNomcrd084() != null) {
			where.append(" AND UPPER(t1.NOMCRD_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getNomcrd084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getNomcrd084().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMCRD_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getPaiscrd084() != null) {
			where.append(" AND UPPER(t1.PAISCRD_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getPaiscrd084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getPaiscrd084().toUpperCase() + "%");
			}
			where.append(" AND t1.PAISCRD_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getPrvcrd084() != null) {
			where.append(" AND UPPER(t1.PRVCRD_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getPrvcrd084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getPrvcrd084().toUpperCase() + "%");
			}
			where.append(" AND t1.PRVCRD_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getMuncrd084() != null) {
			where.append(" AND UPPER(t1.MUNCRD_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getMuncrd084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getMuncrd084().toUpperCase() + "%");
			}
			where.append(" AND t1.MUNCRD_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getDmuncrd084() != null) {
			where.append(" AND UPPER(t1.DMUNCRD_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getDmuncrd084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getDmuncrd084().toUpperCase() + "%");
			}
			where.append(" AND t1.DMUNCRD_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getDircrd084() != null) {
			where.append(" AND UPPER(t1.DIRCRD_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getDircrd084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getDircrd084().toUpperCase() + "%");
			}
			where.append(" AND t1.DIRCRD_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getCpocrd084() != null) {
			where.append(" AND UPPER(t1.CPOCRD_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getCpocrd084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getCpocrd084().toUpperCase() + "%");
			}
			where.append(" AND t1.CPOCRD_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getTitcrd084() != null) {
			where.append(" AND UPPER(t1.TITCRD_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getTitcrd084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getTitcrd084().toUpperCase() + "%");
			}
			where.append(" AND t1.TITCRD_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getOrdexp084() != null) {
			where.append(" AND t1.ORDEXP_084 = ?");
			params.add(ab0484s00.getOrdexp084());
		}
		if (ab0484s00 != null && ab0484s00.getUsualt084() != null) {
			where.append(" AND UPPER(t1.USUALT_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getUsualt084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getUsualt084().toUpperCase() + "%");
			}
			where.append(" AND t1.USUALT_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getFecmod084() != null) {
			where.append(" AND t1.FECMOD_084 = ?");
			params.add(ab0484s00.getFecmod084());
		}
		if (ab0484s00 != null && ab0484s00.getUsumod084() != null) {
			where.append(" AND UPPER(t1.USUMOD_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getUsumod084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getUsumod084().toUpperCase() + "%");
			}
			where.append(" AND t1.USUMOD_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getDesccrd084() != null) {
			where.append(" AND UPPER(t1.DESCCRD_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getDesccrd084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getDesccrd084().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCCRD_084 IS NOT NULL");
		}
		if (ab0484s00 != null && ab0484s00.getTlfcrd084() != null) {
			where.append(" AND UPPER(t1.TLFCRD_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getTlfcrd084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getTlfcrd084().toUpperCase() + "%");
			}
			where.append(" AND t1.TLFCRD_084 IS NOT NULL");
		}

		if (ab0484s00 != null && ab0484s00.getEmailcrd084() != null) {
			where.append(" AND UPPER(t1.EMAILCRD_084) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0484s00.getEmailcrd084().toUpperCase() + "%");
			} else {
				params.add("%" + ab0484s00.getEmailcrd084().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAILCRD_084 IS NOT NULL");
		}

		if (ab0484s00 != null && ab0484s00.getIdape084() != null) {
			where.append(" AND t1.IDAPE_084 = ?");
			params.add(ab0484s00.getIdape084());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
